<?php

/**
 * Plugin Name: CoreDash
 * Description: CoreDash plugin - coredash.app
 * Version: 7.3.24
 * Author: Arjen
 */

//zip -vr coredash.zip ./coredash


$plugin_name = 'coredash';


function coredash_register_custom_settings()
{
    add_options_page('CoreDash', 'CoreDash', 'manage_options', 'coredash_settings', 'coredash_render_custom_settings', 2);
}
add_action('admin_menu', 'coredash_register_custom_settings');


// Add settings link on plugin page
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'coredash_add_settings_link');

function coredash_add_settings_link($links)
{

    $url = esc_url(add_query_arg(
        'page',
        'coredash_render_custom_settings',
        get_admin_url() . 'options-general.php'
    ));

    $settings_link = '<a href="admin.php?page=coredash_settings">Settings</a>';
    array_unshift($links, $settings_link);
    return $links;
}



// Create settings page
function coredash_render_custom_settings()
{
?>
    <div class="wrap">
        <form method="post" action="options.php">
            <?php
            settings_fields('coredash_settings_group');
            do_settings_sections('coredash');
            submit_button();
            ?>
        </form>
    </div>
<?php
}

// Register settings
add_action('admin_init', 'coredash_register_settings');
function coredash_register_settings()
{

    register_setting('coredash_settings_group', 'coredash_api_key');
    register_setting('coredash_settings_group', 'coredash_auto_tagging');
    register_setting('coredash_settings_group', 'coredash_use_beta');
    register_setting('coredash_settings_group', 'coredash_timing');
    register_setting('coredash_settings_group', 'coredash_exclude_patterns');

    add_settings_section('coredash_main_section', 'Core/Dash RUM tracking for WordPress', 'coredash_section_text', 'coredash');

    add_settings_field('coredash_api_key', 'API Key', 'coredash_api_key_input', 'coredash', 'coredash_main_section');
    add_settings_field('coredash_auto_tagging', 'Smart auto tagging', 'coredash_auto_tagging_input', 'coredash', 'coredash_main_section');
    add_settings_field('coredash_use_beta', 'Beta features', 'coredash_use_beta_input', 'coredash', 'coredash_main_section');
    add_settings_field('coredash_timing', 'Timing', 'coredash_timing_input', 'coredash', 'coredash_main_section');
    add_settings_field('coredash_exclude_patterns', 'Exclude URL Patterns', 'coredash_exclude_patterns_input', 'coredash', 'coredash_main_section');
}



function coredash_section_text()
{
    echo '<p style="max-width: 1000px;">The Coredash plugin brings adds real time RUM tracking directly into your WordPress.
Set up the integration to start making informed decisions and delivering better experiences.</p>';
}

function coredash_timing_input()
{
    $coredash_timing = get_option('coredash_timing');
?>
    <select name="coredash_timing">
        <option value="async" <?php selected('async', $coredash_timing); ?>>Early Async</option>
        <option value="async_inject" <?php selected('async_inject', $coredash_timing); ?>>Early Injected</option>
        <option value="idle" <?php selected('idle', $coredash_timing); ?>>During Idle Time</option>
    </select>
    <p class="description" style="max-width: 800px;"><br />
        <b>Early Async</b> loads the script asynchronously as soon as possible. This is the best choice for collecting as much early data as possible. This is the recommended setting for debugging TTFB <br /><br />
        <b>Early Injected</b> loads the script early but prioritizes other discoverable elements such as images. This is your best choice for collecting as much data as possible with little impact. <br /> <br />
        <b>During Idle Time</b> minimizes the Core Web Vitals on your pages. This is the recommended setting for long-term tracking.
    </p>
<?php
}

function coredash_use_beta_input()
{
    $coredash_use_beta = get_option('coredash_use_beta');
    echo '<input type="checkbox" name="coredash_use_beta" value="1"' . checked(1, $coredash_use_beta, false) . '> Use Beta';
    echo '<p class="description" style="max-width: 800px;">Use the beta version of the CoreWebVitals library.</p>';
}

function coredash_api_key_input()
{
    $api_key = get_option('coredash_api_key');
    echo '<input type="text" name="coredash_api_key" value="' . esc_attr($api_key) . '" class="regular-text">';
    echo '<p class="description" style="max-width: 800px;">Your API Key provided by Core/Dash</p>';
}

function coredash_auto_tagging_input()
{
    $auto_tagging = get_option('coredash_auto_tagging');
    echo '<input type="checkbox" name="coredash_auto_tagging" value="1"' . checked(1, $auto_tagging, false) . '> Enable auto tagging';
    echo '<p class="description" style="max-width: 800px;">Anonymously tag the page cache eligibility and logged-in status</p>';
}

function coredash_exclude_patterns_input()
{
    $exclude_patterns = get_option('coredash_exclude_patterns');
    echo '<textarea name="coredash_exclude_patterns" style="width:100%;max-width:400px;height:8rem;">' . esc_textarea($exclude_patterns) . '</textarea>';
    echo '<p class="description" style="max-width: 800px;">Enter URL patterns (e.g /members/*) to exclude from script injection, one per line.</p>';
}

function is_indexable()
{
    if (is_admin()) {
        return false;
    }
    return true;
}



add_action('wp_enqueue_scripts', 'coredash_enqueue_script');
function coredash_enqueue_script()
{



    if (is_indexable()) {

      

        $api_key = get_option('coredash_api_key');
        $auto_tagging = get_option('coredash_auto_tagging');
        $coredash_timing = get_option('coredash_timing');
        $coredash_use_beta = get_option('coredash_use_beta');
        $exclude_patterns = get_option('coredash_exclude_patterns');

        $current_url = $_SERVER['REQUEST_URI'];
        $patterns = explode("\n", $exclude_patterns);
        foreach ($patterns as $pattern) {
            $pattern = trim($pattern);
            if (empty($pattern)) {
                continue;
            } else if (@preg_match('#' . trim($pattern) . '#', $current_url)) {
                return;
            }
        }

        $qs = '';
        if ($coredash_use_beta) {
            $qs = '?beta=true';
        }

        if ($api_key) {

            $rum_url = 'https://rum.corewebvitals.io/cwv/' . esc_attr($api_key) . '.js' . $qs;

            if ($coredash_timing == 'async_inject') {
                wp_register_script('coredash-inline-script', '');
                wp_enqueue_script('coredash-inline-script');
                wp_add_inline_script(
                    'coredash-inline-script',
                    'var script = document.createElement("script");script.src = "' . esc_url($rum_url) . '";document.documentElement.appendChild(script);'
                );
            } elseif ($coredash_timing == 'idle') {
                wp_register_script('coredash-inline-script', '');
                wp_enqueue_script('coredash-inline-script');
                wp_add_inline_script(
                    'coredash-inline-script',
                    'var _cwv_cbf = window.requestIdleCallback || function(cb) {setTimeout(cb, 0);};window.addEventListener("load", function() {_cwv_cbf(function() {var script = document.createElement("script");script.src = "' . esc_url($rum_url) . '";document.body.appendChild(script);});});'
                );
            } else {
                wp_enqueue_script('coredash-script', $rum_url, [], null, ['strategy' => 'async']);
            }

            if ($auto_tagging) {
                $li = '0';
                if (is_user_logged_in()) {
                    $li = current_user_can('administrator') ? '2' : '1';
                }
                wp_add_inline_script('coredash-script', 'window.__CWVLI=' . $li . ';', 'before');
            }

            if (defined('DONOTCACHEPAGE') && DONOTCACHEPAGE == true) {
                wp_add_inline_script('coredash-script', 'window.__CWVL="DONOTCACHEPAGE";', 'before');
            } else {
                if (isset($_COOKIE) && !empty($_COOKIE)) {
                    foreach ($_COOKIE as $name => $value) {
                        if (strpos($name, 'wordpress') === 0) {
                            wp_add_inline_script('coredash-script', 'window.__CWVL="PROBABLY_UNCACHED";', 'before');
                            break;
                        }
                    }
                }
            }
        }
    }
}
?>